// content-script.js for sumo-analyzer-cors-helper
// Listens for postMessage pings from the SPA and relays to background, then responds

function sendCorsHelperPing() {
  if (
    typeof chrome !== 'undefined' &&
    chrome.runtime &&
    chrome.runtime.sendMessage
  ) {
    try {
      // Get extension version from manifest
      const version = chrome.runtime.getManifest().version;

      chrome.runtime.sendMessage({ type: 'CORS_HELPER_PING' }, response => {
        window.postMessage(
          {
            type: 'CORS_HELPER_PONG',
            available: response?.available === true,
            version: version,
          },
          window.location.origin,
        );
      });
    } catch (e) {
      window.postMessage(
        { type: 'CORS_HELPER_PONG', available: false, error: e?.message },
        window.location.origin,
      );
    }
  } else {
    window.postMessage(
      { type: 'CORS_HELPER_PONG', available: false },
      window.location.origin,
    );
  }
}

// Listen for explicit pings from the SPA
window.addEventListener('message', function handleCorsHelperPing(event) {
  // Only accept messages from the same window
  if (event.source !== window) return;
  // Only accept messages from the same origin for security
  if (event.origin !== window.location.origin) return;
  // Strict type check
  if (
    !event.data ||
    typeof event.data !== 'object' ||
    event.data.type !== 'CORS_HELPER_PING'
  )
    return;
  sendCorsHelperPing();
});

// Only ping extension on initial load and when tab becomes visible (reactivated)
sendCorsHelperPing();
document.addEventListener('visibilitychange', () => {
  if (document.visibilityState === 'visible') {
    sendCorsHelperPing();
  }
});
