// Service worker for Chrome extension route handling
// Intercepts requests and serves correct files for SPA routing

self.addEventListener('fetch', event => {
  const url = new URL(event.request.url);
  
  // Only handle extension URLs
  if (!url.protocol.startsWith('chrome-extension:')) {
    return;
  }
  
  // Handle asset requests from subpages - redirect to root spa directory
  if (url.pathname.match(/^\/spa\/[^\/]+\/_next\//)) {
    const assetPath = url.pathname.replace(/^\/spa\/[^\/]+\/(_next\/.*)$/, '/spa/$1');
    event.respondWith(fetch(assetPath));
    return;
  }
  
  // Handle /spa/xxx/ -> /spa/xxx/index.html
  if (url.pathname.match(/^\/spa\/[^\/]+\/$/)) {
    event.respondWith(
      fetch(event.request.url + 'index.html')
        .catch(() => fetch('/spa/index.html'))
    );
    return;
  }
  
  // Handle /spa/ -> /spa/index.html  
  if (url.pathname === '/spa/') {
    event.respondWith(fetch('/spa/index.html'));
    return;
  }
});

self.addEventListener('install', () => {
  // Skip waiting to activate immediately
  self.skipWaiting();
});

self.addEventListener('activate', () => {
  // Take control of all clients immediately
  self.clients.claim();
});
